"""
Builds a simple house scene from filled shapes plus a ground line.

The body is a square, the roof is a triangle, and the sun is a filled circle.
"""

import turtle


screen = turtle.Screen()
screen.setup(width=700, height=500)
screen.title("Python Turtle: House Scene")
screen.bgcolor("skyblue")

pen = turtle.Turtle()
pen.speed("fastest")

pen.penup()
pen.goto(-60, -120)
pen.pendown()
pen.color("sienna")
pen.begin_fill()
for _ in range(4):
    pen.forward(120)
    pen.right(90)
    pen.forward(120)
    pen.left(120)
pen.end_fill()

pen.color("firebrick")
pen.begin_fill()
pen.left(90)
pen.forward(120)
pen.right(90)
for _ in range(3):
    pen.forward(120)
    pen.left(120)
pen.end_fill()

pen.penup()
pen.goto(150, 120)
pen.pendown()
pen.color("gold")
pen.begin_fill()
pen.circle(40)
pen.end_fill()

pen.penup()
pen.goto(-200, -120)
pen.pendown()
pen.color("forest green")
pen.pensize(5)
pen.forward(400)

screen.mainloop()

